﻿using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.Xrm.Sdk;
using PpmsDataService.Models;
using PpmsDataService.VA.PPMS.Context;
using VA.PPMS.Context;

namespace PpmsDataService.V1.Mappers
{
    public class ProviderServicesMap
    {
        public static async Task<IQueryable<ProviderService>> MapProviderServices(List<ppms_providerservice> ppmsProviderServices, string mapRelatedType, PpmsContext context)
        {
            var providerServices = new List<ProviderService> {};
            foreach (var ppmsProviderService in ppmsProviderServices)
            {
                                
                //Populate the Provider Service Details
                var providerService = new ProviderService
                {                       
                    Name = ppmsProviderService.ppms_name,
                    DescriptionOfService = ppmsProviderService.ppms_descriptionofservice,
                    Limitation = ppmsProviderService.ppms_limitation
                };

                //Lookup attribute names
                if (ppmsProviderService.ppms_network != null)
                    providerService.AffiliationName = ppmsProviderService.ppms_network.Name;

                if (ppmsProviderService.ppms_ProviderId != null)
                    providerService.ProviderName = ppmsProviderService.ppms_ProviderId.Name;

                if (ppmsProviderService.ppms_ProviderAgreement != null)
                    providerService.ProviderAgreementName = ppmsProviderService.ppms_ProviderAgreement.Name;

                if (ppmsProviderService.ppms_specialty != null)
                    providerService.SpecialtyName = ppmsProviderService.ppms_specialty.Name;

                /*
                if (ppmsProviderService.ppms_ProviderSpecialty != null)
                    providerService.ProviderSpecialtyName = ppmsProviderService.ppms_ProviderSpecialty.Name;
                */

                if (ppmsProviderService.ppms_caresite != null)
                    providerService.CareSiteLocationAddress = ppmsProviderService.ppms_caresite.Name;

                if (ppmsProviderService.ppms_Organization != null)
                    providerService.OrganiztionGroupName = ppmsProviderService.ppms_Organization.Name;

                //Extract the Related type from queryType string
                if (mapRelatedType.Contains("?$expand=Specialty"))
                    mapRelatedType = "Specialty";
                if (mapRelatedType.Contains("?$expand=Provider"))
                    mapRelatedType = "Provider";
                if (mapRelatedType.Contains("?$expand=ServiceAvailabilities"))
                    mapRelatedType = "ServiceAvailabilities";
                if (mapRelatedType.Contains("?$expand=AgreementProviders"))
                    mapRelatedType = "AgreementProviders";

                //Map Related types switch. 
                switch (mapRelatedType)
                {                    
                    case "Specialty":
                        //Lookup and Map the Specialty
                        var ppmsSpecialty =
                            context.ppms_taxonomySet.FirstOrDefault(i => i.Id == ppmsProviderService.ppms_specialty.Id);
                        var ppmsSpecialtiesList = new List<ppms_taxonomy> { ppmsSpecialty };
                        providerService.Specialty =
                            await SpecialtyMap.MapSpecialties(ppmsSpecialtiesList, "None", context);
                        break;
                    case "Provider":
                        //Lookup and Map the Provider
                        var ppmsProvider =
                            context.AccountSet.FirstOrDefault(i => i.Id == ppmsProviderService.ppms_ProviderId.Id);
                        var ppmsProvidersList = new List<Account> { ppmsProvider };
                        providerService.Provider =
                            await ProviderMap.MapProviders(ppmsProvidersList, "None", context);
                        break;
                    case "ServiceAvailabilities":
                        var ppmsServiceAvailabilities =
                            context.ppms_serviceavailabilitySet.Where(i => i.ppms_ProviderServiceId.Id == ppmsProviderService.Id);
                        var ppmsServiceAvailabilitiesList = ppmsServiceAvailabilities.ToList();
                        providerService.ServiceAvailabilities =
                            await ServiceAvailabilityMap.MapServiceAvailabilities(ppmsServiceAvailabilitiesList, "None",
                                context);
                        break;
                    case "AgreementProviders":
                        var ppmsAgreementProviders =
                            context.ppms_agreementproviderSet.Where(
                                i => i.ppms_ProviderAgreement.Id == ppmsProviderService.Id);
                        var ppmsAgreementProvidersList = ppmsAgreementProviders.ToList();
                        providerService.AgreementProviders =
                            await AgreementProvidersMap.MapAgreementProviders(ppmsAgreementProvidersList, "None",
                                context);
                        break;
                    default:
                        break;
                }



                providerServices.Add(providerService);
                
            }
            return providerServices.AsQueryable();            
        }

        /*
        public static async Task<IQueryable<ProviderService>> MapProviderServicesFull(List<ppms_providerservice> ppmsProviderServices)
        {
            var providerServices = new List<ProviderService> { };
            foreach (var ppmsProviderService in ppmsProviderServices)
            {
                using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
                {
                    //Lookup Provider & Specialty and map them here. then pass in below.                                      
                    //Retrieve the Specialty Record. 
                    RetrieveRequest specialtyRequest = new RetrieveRequest
                    {
                        ColumnSet = new ColumnSet(new string[]
                        {
                            "ppms_codedspecialty", "ppms_specialtycode", "ppms_classification", "ppms_grouping",
                            "ppms_isprimarytaxonomy", "ppms_specialization", "ppms_specialtydescription"
                        }),
                        Target = new EntityReference(ppms_taxonomy.EntityLogicalName,
                            ppmsProviderService.ppms_specialty.Id)
                    };
                    ppms_taxonomy ppmsSpecialty =
                        (ppms_taxonomy)((RetrieveResponse)OrgService.Result.Execute(specialtyRequest)).Entity;

                    //Populate the Service Details
                    var providerService = new ProviderService
                    {
                        Name = ppmsProviderService.ppms_name,
                        DescriptionOfService = ppmsProviderService.ppms_descriptionofservice,
                        Limitation = ppmsProviderService.ppms_limitation
                    };

                    if (ppmsSpecialty.ppms_taxonomyId != null)
                        providerService.Specialty = new Specialty()
                        {
                            Name = ppmsSpecialty.ppms_codedspecialty,
                            SpecialtyCode = ppmsSpecialty.ppms_SpecialtyCode,
                            Classification = ppmsSpecialty.ppms_classification,
                            Grouping = ppmsSpecialty.ppms_grouping,
                            Specialization = ppmsSpecialty.ppms_specialization,
                            SpecialtyDescription = ppmsSpecialty.ppms_specialtydescription
                        };

                    var ppmsProvider = context.AccountSet.FirstOrDefault(i => i.Id == ppmsProviderService.ppms_ProviderId.Id);
                    if (ppmsProvider != null)
                        providerService.Provider = new Provider()
                        {
                            Name = ppmsProvider.Name,
                        };

                    if (ppmsProvider.ppms_NPIId != null) { providerService.Provider.Npi = ppmsProvider.ppms_NPIId.Name; }

                    providerServices.Add(providerService);
                }
            }
            return providerServices.AsQueryable();
        }
        */
    }
}